# coding=utf-8

HUDLabelColor = 16 # Maya Default Color (white) : 16
HUDValueColor = 16 # Maya Default Color (white) : 16
HUDSizeNum = 0 # 0:small, 1:large
unitOfCamSpeed = 'km/h' # m/s, km/h, mph
unitOfVelSpeed = 'km/h' # m/s, km/h, mph
unitOfDistance = 'm' # m, ft


userSettings ={
	'name'  	: 'HUDUser',
	'command' 	: u"os.environ.get('USERNAME')",
	'event' 	: 'NewSceneOpened',
	'lw'    	: 0,
	'section'	: 0,
	'block' 	: 0
}
timeSettings ={
	'name'  	: 'HUDTime',
	'command' 	: "datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')",
	'lw'		: 0,
	'section'	: 0,
	'block' 	: 1
}
sceneNameSettings ={
	'name'  	: 'HUDSceneName',
	'command' 	: u"'.'.join(cmds.file(sceneName=1,shortName=1,q=1).split('.')[:-1])",
	'lw'    	: 0,
	'section'	: 2,
	'block' 	: 0
}

lensSettings ={
	'name'  	: 'HUDLens',
	'label' 	: 'Lens : ',
	'command' 	: "'{:.2f} mm'.format(cmds.getAttr('%s.focalLength'%getCam()))",
	'section'	: 1,
	'block' 	: 0
}
camHeightSettings ={
	'name'  	: 'HUDCamHeight',
	'label' 	: 'Height : ',
	'command' 	: "'{:.2f} {}'.format(convertLinearMag(cmds.getAttr('%s.wm'%getCam())[13]), cmds.currentUnit(l=1, q=1))",
	'section'	: 1,
	'block' 	: 1
}
frameSettings ={
	'name'  	: 'HUDFrame',
	'label' 	: 'Frame : ',
	'command' 	: "cmds.currentTime(q=1)",
	'section'	: 7,
	'block' 	: 1
}
shotLengthSettings ={
	'name'  	: 'HUDShotLength',
	'label' 	: 'Shot Length : ',
	'command' 	: "int(cmds.playbackOptions(max=1,q=1) - cmds.playbackOptions(min=1,q=1)) + 1",
	'lw'		: 110,
	'section'	: 7,
	'block' 	: 0
}
workFrameSettings ={
	'name'  	: 'HUDWorkFrame',
	'label' 	: 'Work frame : ',
	'command' 	: "cmds.currentTime(q=1)",
	'lw'		: 110,
	'section'	: 9,
	'block' 	: 0
}
rangeSettings ={
	'name'  	: 'HUDWorkRange',
	'label' 	: 'Work range : ',
	'command' 	: "'%s - %s'%(int(cmds.playbackOptions(min=1,q=1)),int(cmds.playbackOptions(max=1,q=1)))",
	'lw'		: 110,
	'section'	: 9,
	'block' 	: 1
}
tiltLclSettings ={
	'name'  	: 'HUDTiltLcl',
	'label' 	: 'Tilt_lcl : ',
	'command' 	: u"'{:7.1f}°'.format(float(cmds.getAttr('%s.rx'%getCam())))",
	'lw'		: 100,
	'section'	: 3,
	'block' 	: 0
}
headingLclSettings ={
	'name'  	: 'HUDHeadingLcl',
	'label' 	: 'Heading_lcl : ',
	'command' 	: u"'{:7.1f}°'.format(float(cmds.getAttr('%s.ry'%getCam())))",
	'lw'		: 100,
	'section'	: 3,
	'block' 	: 2
}
rollLclSettings ={
	'name'  	: 'HUDRollLcl',
	'label' 	: 'Roll_lcl : ',
	'command' 	: u"'{:7.1f}°'.format(float(cmds.getAttr('%s.rz'%getCam())))",
	'lw'		: 100,
	'section'	: 3,
	'block' 	: 1
}
tiltGblSettings ={
	'name'  	: 'HUDTiltGbl',
	'label' 	: 'Tilt_gbl : ',
	'command' 	: u"'{:7.1f}°'.format(float(cmds.xform(getCam(),ws=1,q=1,ro=1)[0]))",
	'lw'		: 100,
	'section'	: 3,
	'block' 	: 3
}
headingGblSettings ={
	'name'  	: 'HUDHeadingGbl',
	'label' 	: 'Heading_gbl : ',
	'command' 	: u"'{:7.1f}°'.format(float(cmds.xform(getCam(),ws=1,q=1,ro=1)[1]))",
	'lw'		: 100,
	'section'	: 3,
	'block' 	: 5
}
rollGblSettings ={
	'name'  	: 'HUDRollGbl',
	'label' 	: 'Roll_gbl : ',
	'command' 	: u"'{:7.1f}°'.format(float(cmds.xform(getCam(),ws=1,q=1,ro=1)[2]))",
	'lw'		: 100,
	'section'	: 3,
	'block' 	: 4
}


camVelSettings ={
	'name'  	: 'HUDCamVel',
	'label' 	: 'Cam Vel : ',
	'command' 	: 'getCamVel()',
	'section'	: 4,
	'block' 	: 0
}

camXSettings ={
	'name'  	: 'HUDCamX',
	'label' 	: 'CamX : ',
	'command' 	: "'{:.2f} {}'.format(convertLinearMag(cmds.getAttr('%s.wm'%getCam())[12]), cmds.currentUnit(l=1, q=1))",
	'section'	: 4,
	'block' 	: 1
}
camYSettings ={
	'name'  	: 'HUDCamY',
	'label' 	: 'CamY : ',
	'command' 	: "'{:.2f} {}'.format(convertLinearMag(cmds.getAttr('%s.wm'%getCam())[13]), cmds.currentUnit(l=1, q=1))",
	'section'	: 4,
	'block' 	: 2
}
camZSettings ={
	'name'  	: 'HUDCamZ',
	'label' 	: 'CamZ : ',
	'command' 	: "'{:.2f} {}'.format(convertLinearMag(cmds.getAttr('%s.wm'%getCam())[14]), cmds.currentUnit(l=1, q=1))",
	'section'	: 4,
	'block' 	: 3
}
vel1Settings ={
	'name'  	: 'HUDVel1',
	'label' 	: 'Vel1 : ',
	'command' 	: 'getNodeVel(1)',
	'section'	: 5,
	'block' 	: 0,
	'vis'		: 0,
	'node'		: '',
	'lw'		: 100
}
vel2Settings ={
	'name'  	: 'HUDVel2',
	'label' 	: 'Vel2 : ',
	'command' 	: 'getNodeVel(2)',
	'section'	: 5,
	'block' 	: 1,
	'vis'		: 0,
	'node'		: '',
	'lw'		: 100
}
vel3Settings ={
	'name'  	: 'HUDVel3',
	'label' 	: 'Vel3 : ',
	'command' 	: 'getNodeVel(3)',
	'section'	: 5,
	'block' 	: 2,
	'vis'		: 0,
	'node'		: '',
	'lw'		: 100
}
vel4Settings ={
	'name'  	: 'HUDVel4',
	'label' 	: 'Vel4 : ',
	'command' 	: 'getNodeVel(4)',
	'section'	: 5,
	'block' 	: 3,
	'vis'		: 0,
	'node'		: '',
	'lw'		: 100
}
vel5Settings ={
	'name'  	: 'HUDVel5',
	'label' 	: 'Vel5 : ',
	'command' 	: 'getNodeVel(5)',
	'section'	: 5,
	'block' 	: 4,
	'vis'		: 0,
	'node'		: '',
	'lw'		: 100
}

distance1Settings ={
	'name'  	: 'HUDDistance1',
	'label' 	: 'Dist1 : ',
	'command' 	: 'getDistance(1)',
	'section'	: 6,
	'block' 	: 0,
	'vis'		: 0,
	'node'		: '',
	'lw'		: 100
}
distance2Settings ={
	'name'  	: 'HUDDistance2',
	'label' 	: 'Dist2 : ',
	'command' 	: 'getDistance(2)',
	'section'	: 6,
	'block' 	: 1,
	'vis'		: 0,
	'node'		: '',
	'lw'		: 100
}
distance3Settings ={
	'name'  	: 'HUDDistance3',
	'label' 	: 'Dist3 : ',
	'command' 	: 'getDistance(3)',
	'section'	: 6,
	'block' 	: 2,
	'vis'		: 0,
	'node'		: '',
	'lw'		: 100
}
distance4Settings ={
	'name'  	: 'HUDDistance4',
	'label' 	: 'Dist4 : ',
	'command' 	: 'getDistance(4)',
	'section'	: 6,
	'block' 	: 3,
	'vis'		: 0,
	'node'		: '',
	'lw'		: 100
}
distance5Settings ={
	'name'  	: 'HUDDistance5',
	'label' 	: 'Dist5 : ',
	'command' 	: 'getDistance(5)',
	'section'	: 6,
	'block' 	: 4,
	'vis'		: 0,
	'node'		: '',
	'lw'		: 100
}
camNameSettings ={
	'name'  	: 'HUDCamName',
	'command' 	: 'getCam()',
	'section'	: 2,
	'block' 	: 1,
	'lw'		: 0
}
comment1Settings ={
	'name'  	: 'HUDComment1',
	'label'		: '',
	'command' 	: '',
	'section'	: 0,
	'block' 	: 2,
	'vis'		: 0,
	'lw'		: 0
}
comment2Settings ={
	'name'  	: 'HUDComment2',
	'label'		: '',
	'command' 	: '',
	'section'	: 0,
	'block' 	: 3,
	'vis'		: 0,
	'lw'		: 0
}
comment3Settings ={
	'name'  	: 'HUDComment3',
	'label'		: '',
	'command' 	: '',
	'section'	: 0,
	'block' 	: 4,
	'vis'		: 0,
	'lw'		: 0
}
fpsSettings ={
	'name'  	: 'HUDFramerate',
	'label'		: 'Framerate : ',
	'command' 	: 'getFPS()',
	'section'	: 9,
	'block' 	: 2,
	'lw'		: 110
}